﻿//***************************************************************************************
// Vertex.h Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//
// Definicja struktur wierzchołka i formatów wejścia.
//***************************************************************************************

#ifndef VERTEX_H
#define VERTEX_H

#include "d3dUtil.h"

namespace Vertex
{
	struct AmbientOcclusion
	{
		XMFLOAT3 Pos;
		XMFLOAT3 Normal;
		XMFLOAT2 Tex;
		float AmbientAccess;
	};
}

class InputLayoutDesc
{
public:
	// Init like const int A::a[4] = {0, 1, 2, 3}; in .cpp file.
	static const D3D11_INPUT_ELEMENT_DESC AmbientOcclusion[4];
};

class InputLayouts
{
public:
	static void InitAll(ID3D11Device* device);
	static void DestroyAll();

	static ID3D11InputLayout* AmbientOcclusion;
};

#endif // VERTEX_H
